/* Autogenerated file. Do not edit manually. */
/* tslint:disable */
/* eslint-disable */

import {
  ethers,
  EventFilter,
  Signer,
  BigNumber,
  BigNumberish,
  PopulatedTransaction,
} from "ethers";
import {
  Contract,
  ContractTransaction,
  Overrides,
  PayableOverrides,
  CallOverrides,
} from "@ethersproject/contracts";
import { BytesLike } from "@ethersproject/bytes";
import { Listener, Provider } from "@ethersproject/providers";
import { FunctionFragment, EventFragment, Result } from "@ethersproject/abi";

interface IPoolManagerInterface extends ethers.utils.Interface {
  functions: {
    "allowance(address,address,uint256)": FunctionFragment;
    "approve(address,uint256,uint256)": FunctionFragment;
    "balanceOf(address,uint256)": FunctionFragment;
    "burn(address,uint256,uint256)": FunctionFragment;
    "clear(address,uint256)": FunctionFragment;
    "collectProtocolFees(address,address,uint256)": FunctionFragment;
    "donate(tuple,uint256,uint256,bytes)": FunctionFragment;
    "extsload(bytes32)": FunctionFragment;
    "exttload(bytes32[])": FunctionFragment;
    "initialize(tuple,uint160)": FunctionFragment;
    "isOperator(address,address)": FunctionFragment;
    "mint(address,uint256,uint256)": FunctionFragment;
    "modifyLiquidity(tuple,tuple,bytes)": FunctionFragment;
    "protocolFeeController()": FunctionFragment;
    "protocolFeesAccrued(address)": FunctionFragment;
    "setOperator(address,bool)": FunctionFragment;
    "setProtocolFee(tuple,uint24)": FunctionFragment;
    "setProtocolFeeController(address)": FunctionFragment;
    "settle()": FunctionFragment;
    "settleFor(address)": FunctionFragment;
    "swap(tuple,tuple,bytes)": FunctionFragment;
    "sync(address)": FunctionFragment;
    "take(address,address,uint256)": FunctionFragment;
    "transfer(address,uint256,uint256)": FunctionFragment;
    "transferFrom(address,address,uint256,uint256)": FunctionFragment;
    "unlock(bytes)": FunctionFragment;
    "updateDynamicLPFee(tuple,uint24)": FunctionFragment;
  };

  encodeFunctionData(
    functionFragment: "allowance",
    values: [string, string, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "approve",
    values: [string, BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "balanceOf",
    values: [string, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "burn",
    values: [string, BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "clear",
    values: [string, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "collectProtocolFees",
    values: [string, string, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "donate",
    values: [
      {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      BigNumberish,
      BigNumberish,
      BytesLike
    ]
  ): string;
  encodeFunctionData(functionFragment: "extsload", values: [BytesLike]): string;
  encodeFunctionData(
    functionFragment: "exttload",
    values: [BytesLike[]]
  ): string;
  encodeFunctionData(
    functionFragment: "initialize",
    values: [
      {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      BigNumberish
    ]
  ): string;
  encodeFunctionData(
    functionFragment: "isOperator",
    values: [string, string]
  ): string;
  encodeFunctionData(
    functionFragment: "mint",
    values: [string, BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "modifyLiquidity",
    values: [
      {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      {
        tickLower: BigNumberish;
        tickUpper: BigNumberish;
        liquidityDelta: BigNumberish;
        salt: BytesLike;
      },
      BytesLike
    ]
  ): string;
  encodeFunctionData(
    functionFragment: "protocolFeeController",
    values?: undefined
  ): string;
  encodeFunctionData(
    functionFragment: "protocolFeesAccrued",
    values: [string]
  ): string;
  encodeFunctionData(
    functionFragment: "setOperator",
    values: [string, boolean]
  ): string;
  encodeFunctionData(
    functionFragment: "setProtocolFee",
    values: [
      {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      BigNumberish
    ]
  ): string;
  encodeFunctionData(
    functionFragment: "setProtocolFeeController",
    values: [string]
  ): string;
  encodeFunctionData(functionFragment: "settle", values?: undefined): string;
  encodeFunctionData(functionFragment: "settleFor", values: [string]): string;
  encodeFunctionData(
    functionFragment: "swap",
    values: [
      {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      {
        zeroForOne: boolean;
        amountSpecified: BigNumberish;
        sqrtPriceLimitX96: BigNumberish;
      },
      BytesLike
    ]
  ): string;
  encodeFunctionData(functionFragment: "sync", values: [string]): string;
  encodeFunctionData(
    functionFragment: "take",
    values: [string, string, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "transfer",
    values: [string, BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "transferFrom",
    values: [string, string, BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(functionFragment: "unlock", values: [BytesLike]): string;
  encodeFunctionData(
    functionFragment: "updateDynamicLPFee",
    values: [
      {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      BigNumberish
    ]
  ): string;

  decodeFunctionResult(functionFragment: "allowance", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "approve", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "balanceOf", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "burn", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "clear", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "collectProtocolFees",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "donate", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "extsload", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "exttload", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "initialize", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "isOperator", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "mint", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "modifyLiquidity",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "protocolFeeController",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "protocolFeesAccrued",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "setOperator",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "setProtocolFee",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "setProtocolFeeController",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "settle", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "settleFor", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "swap", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "sync", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "take", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "transfer", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "transferFrom",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "unlock", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "updateDynamicLPFee",
    data: BytesLike
  ): Result;

  events: {
    "Approval(address,address,uint256,uint256)": EventFragment;
    "Donate(bytes32,address,uint256,uint256)": EventFragment;
    "Initialize(bytes32,address,address,uint24,int24,address,uint160,int24)": EventFragment;
    "ModifyLiquidity(bytes32,address,int24,int24,int256,bytes32)": EventFragment;
    "OperatorSet(address,address,bool)": EventFragment;
    "ProtocolFeeControllerUpdated(address)": EventFragment;
    "ProtocolFeeUpdated(bytes32,uint24)": EventFragment;
    "Swap(bytes32,address,int128,int128,uint160,uint128,int24,uint24)": EventFragment;
    "Transfer(address,address,address,uint256,uint256)": EventFragment;
  };

  getEvent(nameOrSignatureOrTopic: "Approval"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Donate"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Initialize"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "ModifyLiquidity"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "OperatorSet"): EventFragment;
  getEvent(
    nameOrSignatureOrTopic: "ProtocolFeeControllerUpdated"
  ): EventFragment;
  getEvent(nameOrSignatureOrTopic: "ProtocolFeeUpdated"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Swap"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Transfer"): EventFragment;
}

export class IPoolManager extends Contract {
  connect(signerOrProvider: Signer | Provider | string): this;
  attach(addressOrName: string): this;
  deployed(): Promise<this>;

  on(event: EventFilter | string, listener: Listener): this;
  once(event: EventFilter | string, listener: Listener): this;
  addListener(eventName: EventFilter | string, listener: Listener): this;
  removeAllListeners(eventName: EventFilter | string): this;
  removeListener(eventName: any, listener: Listener): this;

  interface: IPoolManagerInterface;

  functions: {
    allowance(
      owner: string,
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount: BigNumber;
      0: BigNumber;
    }>;

    "allowance(address,address,uint256)"(
      owner: string,
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount: BigNumber;
      0: BigNumber;
    }>;

    approve(
      spender: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "approve(address,uint256,uint256)"(
      spender: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    balanceOf(
      owner: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount: BigNumber;
      0: BigNumber;
    }>;

    "balanceOf(address,uint256)"(
      owner: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount: BigNumber;
      0: BigNumber;
    }>;

    burn(
      from: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "burn(address,uint256,uint256)"(
      from: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    clear(
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "clear(address,uint256)"(
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    collectProtocolFees(
      recipient: string,
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "collectProtocolFees(address,address,uint256)"(
      recipient: string,
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    donate(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      amount0: BigNumberish,
      amount1: BigNumberish,
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "donate((address,address,uint24,int24,address),uint256,uint256,bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      amount0: BigNumberish,
      amount1: BigNumberish,
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "extsload(bytes32)"(
      slot: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      value: string;
      0: string;
    }>;

    "extsload(bytes32,uint256)"(
      startSlot: BytesLike,
      nSlots: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      values: string[];
      0: string[];
    }>;

    "extsload(bytes32[])"(
      slots: BytesLike[],
      overrides?: CallOverrides
    ): Promise<{
      values: string[];
      0: string[];
    }>;

    "exttload(bytes32[])"(
      slots: BytesLike[],
      overrides?: CallOverrides
    ): Promise<{
      values: string[];
      0: string[];
    }>;

    "exttload(bytes32)"(
      slot: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      value: string;
      0: string;
    }>;

    initialize(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "initialize((address,address,uint24,int24,address),uint160)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    isOperator(
      owner: string,
      spender: string,
      overrides?: CallOverrides
    ): Promise<{
      approved: boolean;
      0: boolean;
    }>;

    "isOperator(address,address)"(
      owner: string,
      spender: string,
      overrides?: CallOverrides
    ): Promise<{
      approved: boolean;
      0: boolean;
    }>;

    mint(
      to: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "mint(address,uint256,uint256)"(
      to: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    modifyLiquidity(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        tickLower: BigNumberish;
        tickUpper: BigNumberish;
        liquidityDelta: BigNumberish;
        salt: BytesLike;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "modifyLiquidity((address,address,uint24,int24,address),(int24,int24,int256,bytes32),bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        tickLower: BigNumberish;
        tickUpper: BigNumberish;
        liquidityDelta: BigNumberish;
        salt: BytesLike;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    protocolFeeController(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "protocolFeeController()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    protocolFeesAccrued(
      currency: string,
      overrides?: CallOverrides
    ): Promise<{
      amount: BigNumber;
      0: BigNumber;
    }>;

    "protocolFeesAccrued(address)"(
      currency: string,
      overrides?: CallOverrides
    ): Promise<{
      amount: BigNumber;
      0: BigNumber;
    }>;

    setOperator(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "setOperator(address,bool)"(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    setProtocolFee(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newProtocolFee: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "setProtocolFee((address,address,uint24,int24,address),uint24)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newProtocolFee: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    setProtocolFeeController(
      controller: string,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "setProtocolFeeController(address)"(
      controller: string,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    settle(overrides?: PayableOverrides): Promise<ContractTransaction>;

    "settle()"(overrides?: PayableOverrides): Promise<ContractTransaction>;

    settleFor(
      recipient: string,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "settleFor(address)"(
      recipient: string,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    swap(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        zeroForOne: boolean;
        amountSpecified: BigNumberish;
        sqrtPriceLimitX96: BigNumberish;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "swap((address,address,uint24,int24,address),(bool,int256,uint160),bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        zeroForOne: boolean;
        amountSpecified: BigNumberish;
        sqrtPriceLimitX96: BigNumberish;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    sync(currency: string, overrides?: Overrides): Promise<ContractTransaction>;

    "sync(address)"(
      currency: string,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    take(
      currency: string,
      to: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "take(address,address,uint256)"(
      currency: string,
      to: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    transfer(
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "transfer(address,uint256,uint256)"(
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    transferFrom(
      sender: string,
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "transferFrom(address,address,uint256,uint256)"(
      sender: string,
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    unlock(
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "unlock(bytes)"(
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    updateDynamicLPFee(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newDynamicLPFee: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "updateDynamicLPFee((address,address,uint24,int24,address),uint24)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newDynamicLPFee: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;
  };

  allowance(
    owner: string,
    spender: string,
    id: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  "allowance(address,address,uint256)"(
    owner: string,
    spender: string,
    id: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  approve(
    spender: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "approve(address,uint256,uint256)"(
    spender: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  balanceOf(
    owner: string,
    id: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  "balanceOf(address,uint256)"(
    owner: string,
    id: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  burn(
    from: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "burn(address,uint256,uint256)"(
    from: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  clear(
    currency: string,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "clear(address,uint256)"(
    currency: string,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  collectProtocolFees(
    recipient: string,
    currency: string,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "collectProtocolFees(address,address,uint256)"(
    recipient: string,
    currency: string,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  donate(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    amount0: BigNumberish,
    amount1: BigNumberish,
    hookData: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "donate((address,address,uint24,int24,address),uint256,uint256,bytes)"(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    amount0: BigNumberish,
    amount1: BigNumberish,
    hookData: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "extsload(bytes32)"(
    slot: BytesLike,
    overrides?: CallOverrides
  ): Promise<string>;

  "extsload(bytes32,uint256)"(
    startSlot: BytesLike,
    nSlots: BigNumberish,
    overrides?: CallOverrides
  ): Promise<string[]>;

  "extsload(bytes32[])"(
    slots: BytesLike[],
    overrides?: CallOverrides
  ): Promise<string[]>;

  "exttload(bytes32[])"(
    slots: BytesLike[],
    overrides?: CallOverrides
  ): Promise<string[]>;

  "exttload(bytes32)"(
    slot: BytesLike,
    overrides?: CallOverrides
  ): Promise<string>;

  initialize(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    sqrtPriceX96: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "initialize((address,address,uint24,int24,address),uint160)"(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    sqrtPriceX96: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  isOperator(
    owner: string,
    spender: string,
    overrides?: CallOverrides
  ): Promise<boolean>;

  "isOperator(address,address)"(
    owner: string,
    spender: string,
    overrides?: CallOverrides
  ): Promise<boolean>;

  mint(
    to: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "mint(address,uint256,uint256)"(
    to: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  modifyLiquidity(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    params: {
      tickLower: BigNumberish;
      tickUpper: BigNumberish;
      liquidityDelta: BigNumberish;
      salt: BytesLike;
    },
    hookData: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "modifyLiquidity((address,address,uint24,int24,address),(int24,int24,int256,bytes32),bytes)"(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    params: {
      tickLower: BigNumberish;
      tickUpper: BigNumberish;
      liquidityDelta: BigNumberish;
      salt: BytesLike;
    },
    hookData: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  protocolFeeController(overrides?: CallOverrides): Promise<string>;

  "protocolFeeController()"(overrides?: CallOverrides): Promise<string>;

  protocolFeesAccrued(
    currency: string,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  "protocolFeesAccrued(address)"(
    currency: string,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  setOperator(
    operator: string,
    approved: boolean,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "setOperator(address,bool)"(
    operator: string,
    approved: boolean,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  setProtocolFee(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    newProtocolFee: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "setProtocolFee((address,address,uint24,int24,address),uint24)"(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    newProtocolFee: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  setProtocolFeeController(
    controller: string,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "setProtocolFeeController(address)"(
    controller: string,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  settle(overrides?: PayableOverrides): Promise<ContractTransaction>;

  "settle()"(overrides?: PayableOverrides): Promise<ContractTransaction>;

  settleFor(
    recipient: string,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "settleFor(address)"(
    recipient: string,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  swap(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    params: {
      zeroForOne: boolean;
      amountSpecified: BigNumberish;
      sqrtPriceLimitX96: BigNumberish;
    },
    hookData: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "swap((address,address,uint24,int24,address),(bool,int256,uint160),bytes)"(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    params: {
      zeroForOne: boolean;
      amountSpecified: BigNumberish;
      sqrtPriceLimitX96: BigNumberish;
    },
    hookData: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  sync(currency: string, overrides?: Overrides): Promise<ContractTransaction>;

  "sync(address)"(
    currency: string,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  take(
    currency: string,
    to: string,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "take(address,address,uint256)"(
    currency: string,
    to: string,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  transfer(
    receiver: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "transfer(address,uint256,uint256)"(
    receiver: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  transferFrom(
    sender: string,
    receiver: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "transferFrom(address,address,uint256,uint256)"(
    sender: string,
    receiver: string,
    id: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  unlock(data: BytesLike, overrides?: Overrides): Promise<ContractTransaction>;

  "unlock(bytes)"(
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  updateDynamicLPFee(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    newDynamicLPFee: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "updateDynamicLPFee((address,address,uint24,int24,address),uint24)"(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    newDynamicLPFee: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  callStatic: {
    allowance(
      owner: string,
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "allowance(address,address,uint256)"(
      owner: string,
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    approve(
      spender: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<boolean>;

    "approve(address,uint256,uint256)"(
      spender: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<boolean>;

    balanceOf(
      owner: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "balanceOf(address,uint256)"(
      owner: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    burn(
      from: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "burn(address,uint256,uint256)"(
      from: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    clear(
      currency: string,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "clear(address,uint256)"(
      currency: string,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    collectProtocolFees(
      recipient: string,
      currency: string,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "collectProtocolFees(address,address,uint256)"(
      recipient: string,
      currency: string,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    donate(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      amount0: BigNumberish,
      amount1: BigNumberish,
      hookData: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "donate((address,address,uint24,int24,address),uint256,uint256,bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      amount0: BigNumberish,
      amount1: BigNumberish,
      hookData: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "extsload(bytes32)"(
      slot: BytesLike,
      overrides?: CallOverrides
    ): Promise<string>;

    "extsload(bytes32,uint256)"(
      startSlot: BytesLike,
      nSlots: BigNumberish,
      overrides?: CallOverrides
    ): Promise<string[]>;

    "extsload(bytes32[])"(
      slots: BytesLike[],
      overrides?: CallOverrides
    ): Promise<string[]>;

    "exttload(bytes32[])"(
      slots: BytesLike[],
      overrides?: CallOverrides
    ): Promise<string[]>;

    "exttload(bytes32)"(
      slot: BytesLike,
      overrides?: CallOverrides
    ): Promise<string>;

    initialize(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: CallOverrides
    ): Promise<number>;

    "initialize((address,address,uint24,int24,address),uint160)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: CallOverrides
    ): Promise<number>;

    isOperator(
      owner: string,
      spender: string,
      overrides?: CallOverrides
    ): Promise<boolean>;

    "isOperator(address,address)"(
      owner: string,
      spender: string,
      overrides?: CallOverrides
    ): Promise<boolean>;

    mint(
      to: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "mint(address,uint256,uint256)"(
      to: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    modifyLiquidity(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        tickLower: BigNumberish;
        tickUpper: BigNumberish;
        liquidityDelta: BigNumberish;
        salt: BytesLike;
      },
      hookData: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      callerDelta: BigNumber;
      feesAccrued: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    "modifyLiquidity((address,address,uint24,int24,address),(int24,int24,int256,bytes32),bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        tickLower: BigNumberish;
        tickUpper: BigNumberish;
        liquidityDelta: BigNumberish;
        salt: BytesLike;
      },
      hookData: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      callerDelta: BigNumber;
      feesAccrued: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    protocolFeeController(overrides?: CallOverrides): Promise<string>;

    "protocolFeeController()"(overrides?: CallOverrides): Promise<string>;

    protocolFeesAccrued(
      currency: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "protocolFeesAccrued(address)"(
      currency: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    setOperator(
      operator: string,
      approved: boolean,
      overrides?: CallOverrides
    ): Promise<boolean>;

    "setOperator(address,bool)"(
      operator: string,
      approved: boolean,
      overrides?: CallOverrides
    ): Promise<boolean>;

    setProtocolFee(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newProtocolFee: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "setProtocolFee((address,address,uint24,int24,address),uint24)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newProtocolFee: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    setProtocolFeeController(
      controller: string,
      overrides?: CallOverrides
    ): Promise<void>;

    "setProtocolFeeController(address)"(
      controller: string,
      overrides?: CallOverrides
    ): Promise<void>;

    settle(overrides?: CallOverrides): Promise<BigNumber>;

    "settle()"(overrides?: CallOverrides): Promise<BigNumber>;

    settleFor(recipient: string, overrides?: CallOverrides): Promise<BigNumber>;

    "settleFor(address)"(
      recipient: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    swap(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        zeroForOne: boolean;
        amountSpecified: BigNumberish;
        sqrtPriceLimitX96: BigNumberish;
      },
      hookData: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "swap((address,address,uint24,int24,address),(bool,int256,uint160),bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        zeroForOne: boolean;
        amountSpecified: BigNumberish;
        sqrtPriceLimitX96: BigNumberish;
      },
      hookData: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    sync(currency: string, overrides?: CallOverrides): Promise<void>;

    "sync(address)"(currency: string, overrides?: CallOverrides): Promise<void>;

    take(
      currency: string,
      to: string,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "take(address,address,uint256)"(
      currency: string,
      to: string,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    transfer(
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<boolean>;

    "transfer(address,uint256,uint256)"(
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<boolean>;

    transferFrom(
      sender: string,
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<boolean>;

    "transferFrom(address,address,uint256,uint256)"(
      sender: string,
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<boolean>;

    unlock(data: BytesLike, overrides?: CallOverrides): Promise<string>;

    "unlock(bytes)"(
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<string>;

    updateDynamicLPFee(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newDynamicLPFee: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "updateDynamicLPFee((address,address,uint24,int24,address),uint24)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newDynamicLPFee: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;
  };

  filters: {
    Approval(
      owner: string | null,
      spender: string | null,
      id: BigNumberish | null,
      amount: null
    ): EventFilter;

    Donate(
      id: BytesLike | null,
      sender: string | null,
      amount0: null,
      amount1: null
    ): EventFilter;

    Initialize(
      id: BytesLike | null,
      currency0: string | null,
      currency1: string | null,
      fee: null,
      tickSpacing: null,
      hooks: null,
      sqrtPriceX96: null,
      tick: null
    ): EventFilter;

    ModifyLiquidity(
      id: BytesLike | null,
      sender: string | null,
      tickLower: null,
      tickUpper: null,
      liquidityDelta: null,
      salt: null
    ): EventFilter;

    OperatorSet(
      owner: string | null,
      operator: string | null,
      approved: null
    ): EventFilter;

    ProtocolFeeControllerUpdated(
      protocolFeeController: string | null
    ): EventFilter;

    ProtocolFeeUpdated(id: BytesLike | null, protocolFee: null): EventFilter;

    Swap(
      id: BytesLike | null,
      sender: string | null,
      amount0: null,
      amount1: null,
      sqrtPriceX96: null,
      liquidity: null,
      tick: null,
      fee: null
    ): EventFilter;

    Transfer(
      caller: null,
      from: string | null,
      to: string | null,
      id: BigNumberish | null,
      amount: null
    ): EventFilter;
  };

  estimateGas: {
    allowance(
      owner: string,
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "allowance(address,address,uint256)"(
      owner: string,
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    approve(
      spender: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "approve(address,uint256,uint256)"(
      spender: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    balanceOf(
      owner: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "balanceOf(address,uint256)"(
      owner: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    burn(
      from: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "burn(address,uint256,uint256)"(
      from: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    clear(
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "clear(address,uint256)"(
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    collectProtocolFees(
      recipient: string,
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "collectProtocolFees(address,address,uint256)"(
      recipient: string,
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    donate(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      amount0: BigNumberish,
      amount1: BigNumberish,
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "donate((address,address,uint24,int24,address),uint256,uint256,bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      amount0: BigNumberish,
      amount1: BigNumberish,
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "extsload(bytes32)"(
      slot: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "extsload(bytes32,uint256)"(
      startSlot: BytesLike,
      nSlots: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "extsload(bytes32[])"(
      slots: BytesLike[],
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "exttload(bytes32[])"(
      slots: BytesLike[],
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "exttload(bytes32)"(
      slot: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    initialize(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "initialize((address,address,uint24,int24,address),uint160)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    isOperator(
      owner: string,
      spender: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "isOperator(address,address)"(
      owner: string,
      spender: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    mint(
      to: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "mint(address,uint256,uint256)"(
      to: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    modifyLiquidity(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        tickLower: BigNumberish;
        tickUpper: BigNumberish;
        liquidityDelta: BigNumberish;
        salt: BytesLike;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "modifyLiquidity((address,address,uint24,int24,address),(int24,int24,int256,bytes32),bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        tickLower: BigNumberish;
        tickUpper: BigNumberish;
        liquidityDelta: BigNumberish;
        salt: BytesLike;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    protocolFeeController(overrides?: CallOverrides): Promise<BigNumber>;

    "protocolFeeController()"(overrides?: CallOverrides): Promise<BigNumber>;

    protocolFeesAccrued(
      currency: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "protocolFeesAccrued(address)"(
      currency: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    setOperator(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "setOperator(address,bool)"(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<BigNumber>;

    setProtocolFee(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newProtocolFee: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "setProtocolFee((address,address,uint24,int24,address),uint24)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newProtocolFee: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    setProtocolFeeController(
      controller: string,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "setProtocolFeeController(address)"(
      controller: string,
      overrides?: Overrides
    ): Promise<BigNumber>;

    settle(overrides?: PayableOverrides): Promise<BigNumber>;

    "settle()"(overrides?: PayableOverrides): Promise<BigNumber>;

    settleFor(
      recipient: string,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "settleFor(address)"(
      recipient: string,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    swap(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        zeroForOne: boolean;
        amountSpecified: BigNumberish;
        sqrtPriceLimitX96: BigNumberish;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "swap((address,address,uint24,int24,address),(bool,int256,uint160),bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        zeroForOne: boolean;
        amountSpecified: BigNumberish;
        sqrtPriceLimitX96: BigNumberish;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    sync(currency: string, overrides?: Overrides): Promise<BigNumber>;

    "sync(address)"(
      currency: string,
      overrides?: Overrides
    ): Promise<BigNumber>;

    take(
      currency: string,
      to: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "take(address,address,uint256)"(
      currency: string,
      to: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    transfer(
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "transfer(address,uint256,uint256)"(
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    transferFrom(
      sender: string,
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "transferFrom(address,address,uint256,uint256)"(
      sender: string,
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    unlock(data: BytesLike, overrides?: Overrides): Promise<BigNumber>;

    "unlock(bytes)"(data: BytesLike, overrides?: Overrides): Promise<BigNumber>;

    updateDynamicLPFee(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newDynamicLPFee: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "updateDynamicLPFee((address,address,uint24,int24,address),uint24)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newDynamicLPFee: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;
  };

  populateTransaction: {
    allowance(
      owner: string,
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "allowance(address,address,uint256)"(
      owner: string,
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    approve(
      spender: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "approve(address,uint256,uint256)"(
      spender: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    balanceOf(
      owner: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "balanceOf(address,uint256)"(
      owner: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    burn(
      from: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "burn(address,uint256,uint256)"(
      from: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    clear(
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "clear(address,uint256)"(
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    collectProtocolFees(
      recipient: string,
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "collectProtocolFees(address,address,uint256)"(
      recipient: string,
      currency: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    donate(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      amount0: BigNumberish,
      amount1: BigNumberish,
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "donate((address,address,uint24,int24,address),uint256,uint256,bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      amount0: BigNumberish,
      amount1: BigNumberish,
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "extsload(bytes32)"(
      slot: BytesLike,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "extsload(bytes32,uint256)"(
      startSlot: BytesLike,
      nSlots: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "extsload(bytes32[])"(
      slots: BytesLike[],
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "exttload(bytes32[])"(
      slots: BytesLike[],
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "exttload(bytes32)"(
      slot: BytesLike,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    initialize(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "initialize((address,address,uint24,int24,address),uint160)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    isOperator(
      owner: string,
      spender: string,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "isOperator(address,address)"(
      owner: string,
      spender: string,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    mint(
      to: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "mint(address,uint256,uint256)"(
      to: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    modifyLiquidity(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        tickLower: BigNumberish;
        tickUpper: BigNumberish;
        liquidityDelta: BigNumberish;
        salt: BytesLike;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "modifyLiquidity((address,address,uint24,int24,address),(int24,int24,int256,bytes32),bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        tickLower: BigNumberish;
        tickUpper: BigNumberish;
        liquidityDelta: BigNumberish;
        salt: BytesLike;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    protocolFeeController(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "protocolFeeController()"(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    protocolFeesAccrued(
      currency: string,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "protocolFeesAccrued(address)"(
      currency: string,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    setOperator(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "setOperator(address,bool)"(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    setProtocolFee(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newProtocolFee: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "setProtocolFee((address,address,uint24,int24,address),uint24)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newProtocolFee: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    setProtocolFeeController(
      controller: string,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "setProtocolFeeController(address)"(
      controller: string,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    settle(overrides?: PayableOverrides): Promise<PopulatedTransaction>;

    "settle()"(overrides?: PayableOverrides): Promise<PopulatedTransaction>;

    settleFor(
      recipient: string,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "settleFor(address)"(
      recipient: string,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    swap(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        zeroForOne: boolean;
        amountSpecified: BigNumberish;
        sqrtPriceLimitX96: BigNumberish;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "swap((address,address,uint24,int24,address),(bool,int256,uint160),bytes)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      params: {
        zeroForOne: boolean;
        amountSpecified: BigNumberish;
        sqrtPriceLimitX96: BigNumberish;
      },
      hookData: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    sync(
      currency: string,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "sync(address)"(
      currency: string,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    take(
      currency: string,
      to: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "take(address,address,uint256)"(
      currency: string,
      to: string,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    transfer(
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "transfer(address,uint256,uint256)"(
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    transferFrom(
      sender: string,
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "transferFrom(address,address,uint256,uint256)"(
      sender: string,
      receiver: string,
      id: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    unlock(
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "unlock(bytes)"(
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    updateDynamicLPFee(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newDynamicLPFee: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "updateDynamicLPFee((address,address,uint24,int24,address),uint24)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      newDynamicLPFee: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;
  };
}
